local super = require "Object"

Regression = super:new()

function Regression:init()
    self._n = 0
    self._xs = {}
    self._ys = {}
    self._xmin = math.huge
    self._xmax = -math.huge
    self._ymin = math.huge
    self._ymax = -math.huge
    self._r2 = nil
end

function Regression:update(x, y)
    if x and y then
        self._n = self._n + 1
        self._xs[#self._xs + 1] = x
        self._ys[#self._ys + 1] = y
        self._xmin = math.min(self._xmin, x)
        self._xmax = math.max(self._xmax, x)
        self._ymin = math.min(self._ymin, y)
        self._ymax = math.max(self._ymax, y)
    end
end

function Regression:finish()
    return false
end

function Regression:getEquation()
    return nil
end

function Regression:getValue(x)
    return nil
end

function Regression:getR2()
    return self._r2
end

return Regression
